---
Note type: Reference
tags:
  - ZoteroReference
  - "#REFERENCE"
Reference type: journalArticle
Bib_ref: "Mees-Buss J, Welch C and Piekkari R (2020) From templates to heuristics: How and why to move beyond the Gioia methodology. _Organizational Research Methods_ 25(2): 405–429."
Title: "From templates to heuristics: How and why to move beyond the Gioia methodology"
Authors: Jacqueline Mees-Buss, Catherine Welch, Rebecca Piekkari
Year: 2020-01-01T00:00:00+00:00
Journal-publisher: Organizational Research Methods
Read: Read
Related areas:
  - "[[Research]]"
  - "[[Teaching]]"
Related projects:
  - "[[SOC301 Social Research Methods Course]]"
  - "[[Paper Y]]"
Related tasks: 
Related references: 
Related zettels:
  - "[[abductive analysis]]"
  - "[[coding inductive to abductive]]"
  - "[[Gioia methodology]]"
  - "[[hermeneutic interpretivism]]"
Related meeting notes: 
Related resources: 
Related people:
  - "[[Jacqueline Mees-Buss]]"
  - "[[Catherine Welch]]"
  - "[[Rebecca Piekkari]]"
aliases:
  - '"From templates to heuristics: How and why to move beyond the Gioia methodology"'
Creation date: 2024-05-27
Last modified: 2024-05-27
---

## Overview

### Context

### RQ

### Thesis

### Methodology

### Theoretical approach

### Findings

### Contributions

### Striking points

### Further research suggested

### My ideas/responses

### Useful references

## Fleeting notes

## Summary

## Overview

### Context

 “Templates offer widely recognized and institutionalized “recipes” that reduce the epistemological and methodological dilemmas of doing research to a clearly delineated set of steps.” ([[Mees-Buss et al. 2020]], p. 406)

The [[Gioia methodology]] is a particularly popular template and “to some degree it has become the standard for conducting [[interpretive research]]” ([[Mees-Buss et al. 2020]], p. 406)

### Aim

### RQ

 “how to establish the rigor and credibility of the interpretive process so that the theories we produce merit scientific status.” ([[Mees-Buss et al. 2020]], p. 406)

### Thesis

 “the inductive route to theory that {the [[Gioia methodology]]} offers does not address the challenges of interpretation” ([[Mees-Buss et al. 2020]], p. 405)

 “As an alternative, we propose a return to the epistemological tradition of hermeneutics.” ([[Mees-Buss et al. 2020]], p. 405)

- “fieldwork informed by a hermeneutic orientation is able to generate credible and novel theory by confronting the challenges of interpretation head on.” ([[Mees-Buss et al. 2020]], p. 405)
- “This process cannot be represented by the orderly steps of a template.” ([[Mees-Buss et al. 2020]], p. 405)
- “a return to a hermeneutic orientation opens the way to more plausible and insightful theories based on **interpretive** rather than **procedural rigor**” ([[Mees-Buss et al. 2020]], p. 405)

### Methodology

 “we trace {the [[Gioia methodology]]’s} epistemological assumptions. We argue that despite the mixed signals, the Gioia methodology is based on a **naturalist** orientation.” ([[Mees-Buss et al. 2020]], p. 406)

### Theoretical framing

Van Maanen’s (1979) hermeneutic approach to field research ([[Mees-Buss et al. 2020]], p. 406)

### Findings

### Contributions

### Striking points

 “Our analysis has broader implications not only for qualitative researchers working across diverse traditions but also for **quantitative social researchers** (Zyphur & Pierides, 2017). They too run the risk of denying the subjective nature of the social world they investigate, and their data are equally in need of interpretation” ([[Mees-Buss et al. 2020]], p. 423)

“more critical perspectives“ “may disagree with our position and emphasize that the struggle over meaning is inherently political and ideological (e.g., Willmott, 2008).” ([[Mees-Buss et al. 2020]], p. 424)

### Further research suggested

### My ideas/responses

### Useful references

Roots for [[hermeneutic interpretivism]]:

- Schütz, A. (1954). Concept and theory formation in the social sciences. The Journal of Philosophy, 51(9), 257–273.
- Schütz, A. (1960). The social world and the theory of social action. Social Research, 27(4), 203–221.
- Van Maanen, J. (1979). The fact of fiction in organizational ethnography. Administrative Science Quarterly, 24 (4), 539–550.
- Van Maanen, J. (2011). Tales of the field: On writing ethnography (2nd ed.). University of Chicago Press.
- Van Maanen, J., Sørensen, J. B., & Mitchell, T. R. (2007). The interplay between theory and method. Academy of Management Review, 32(4), 1145–1154.
- Silverman, D. (1989). Six rules of qualitative research: A post-romantic argument. Symbolic Interaction, 12(2), 215–230.
- Silverman, D. (2013). Doing qualitative research: A practical handbook (4th ed.). SAGE.
- Silverman, D. (2017). How was it for you? The interview society and the irresistible rise of the (poorly analyzed) interview. Qualitative Research, 17(2), 144–158.
- Silverman, D. (2020). Interpreting qualitative data (6th ed.). SAGE

Coherent methodological work:

- “Locke, K., Golden-Biddle, K., & Feldman, M. S. (2008). Making doubt generative: Rethinking the role of doubt in the research process. Organization Science, 19(6), 907–918.”
- “Klag, M., & Langley, A. (2013). Approaching the conceptual leap in qualitative research. International Journal of Management Reviews, 15(2), 149–166.”
- “Kornberger, M., & Mantere, S. (2020). Thought experiments and philosophy in organizational research. Organization Theory, 1(3). https://doi.org/10.1177/2631787720942524”

## Summary

### [[interpretive research]]

- “Interpretive researchers affirm that social action is imbued with meaning that cannot be understood through observation and measurement alone but must be interpreted.” ([[Mees-Buss et al. 2020]], p. 405)
- “Interpretation is unavoidable because the meaning of social action cannot be gained from direct observation alone. This meaning is not given but is **constructed**, both by those involved and by the researchers seeking to explain it.” ([[Mees-Buss et al. 2020]], p. 407)
- **3 sets of interpretive challenges tied to the unavoidable subjectivity of meaning**
    - Challenge 1: Interpreting subject field data
    - Challenge 2: Confronting researcher subjectivity in theorizing the data
    - Challenge 3: Establishing plausibility of the theoretical conclusions  
- “**Two [[epistemological]] orientations** in particular have been important to the evolution of interpretive research methodologies in management:” ([[Mees-Buss et al. 2020]], p. 407)
    - **Naturalist**
    - **Hermeneutic**

### The Naturalist Orientation Toward Interpretation

- “The premise of this methodological tradition is that the researcher can access the subjective meaning with which participants imbue their actions by faithfully reproducing their experiences, as related through their own actions and words (Gubrium & Holstein, 1997).” ([[Mees-Buss et al. 2020]], p. 408)
- **Roots**:
    - “the immediate inspiration for this methodological approach was [[symbolic interactionism]] (Athens, 2010)” ([[Mees-Buss et al. 2020]], p. 408)
    - “can be traced back to [[phenomenology]] and its concern to provide an accurate description of lived experience as the basis for theories in the social sciences (Brinkmann, 2018).” ([[Mees-Buss et al. 2020]], p. 408)
    - “Lincoln and Guba’s (1985) guide to naturalist inquiry {…} explicitly incorporat{ed} a [[grounded theory approach to inductive analysis.” ([[Mees-Buss et al. 2020]], p. 410)
    - “The early naturalist texts present themselves as offering a new approach or even “paradigm” in **direct opposition to quantitative research.**” ([[Mees-Buss et al. 2020]], p. 408)
        - “researcher subjectivity—in particular, the researcher’s ability to respond emotionally as well as intellectually to social cues—is seen as an advantage in overcoming the first challenge of interpreting subjective field data” ([[Mees-Buss et al. 2020]], p. 408)
        - “**credible** and **plausible** theory is assured through systematic procedures for organizing and structuring data.” ([[Mees-Buss et al. 2020]], p. 406)
- **Key exemplars**:
    - [[Lincoln & Guba 1985]]
    - [[Guba & Lincoln 1982]] - “the appropriate response of inquirers to this natural and unavoidable interactivity is to {...} exploit the insights it lends” (p. 250)
    - [[Gioia methodology]]
    - ““first-generation” grounded theory (as codified by Strauss & Corbin, 1990)” ([[Mees-Buss et al. 2020]], p. 423)
    - “Eisenhardt’s (1989) case study roadmap” ([[Mees-Buss et al. 2020]], p. 423)
- **3 sets of interpretive challenges tied to the unavoidable subjectivity of meaning**
    - Challenge 1: Interpreting subject field data
        - “Researchers need to practice their use of empathy, bracket their own preconceptions and judgments, and report the meaning of research participants faithfully.” ([[Mees-Buss et al. 2020]], p. 408)
        - “The underlying epistemological assumption is that it is possible for meaning to be transmitted from the researched to the researcher in a relatively unproblematic way, provided the researcher manages his or her own subjectivity and knows how to use it effectively as a resource.” ([[Mees-Buss et al. 2020]], p. 408)
    - Challenge 2: Confronting researcher subjectivity in theorizing the data
        - “The use of {particular analytic} procedures will ensure that the theory is grounded in the data, keeping the researcher’s own theoretical preferences and subjective biases at bay.” ([[Mees-Buss et al. 2020]], p. 408)
        - “The analytical procedures for this inductive process include systematic techniques developed by [[grounded theory|grounded theorists]], such as [[thematic coding]]” ([[Mees-Buss et al. 2020]], p. 408)
        - “The underlying assumption is that careful data management and processing enable the identification of abstract categories that remain true to the actions and words of study participants. In this way, “theory arises from the data rather than being imposed on them” (Guba & Lincoln, 1982, p. 244).” ([[Mees-Buss et al. 2020]], p. 408)
    - Challenge 3: Establishing plausibility of the theoretical conclusions  
        - “Plausibility is achieved through traceability and transparency: demonstrating a tight fit between data and theory. {…}

            In other words, theories must represent and be traceable to participants’ accounts.” ([[Mees-Buss et al. 2020]], p. 408)

- **Risks**:
    - “Demonstrating a systematic process—**procedural rigor**—does not necessarily lead to **interpretive rigor** and thus restricts the development of interesting and plausible theory.” ([[Mees-Buss et al. 2020]], p. 406)
    - “the naturalist orientation risks amounting to a form of naïve [[inductivism]]: in other words, the assertion that one’s understanding of the world is simply derived from one’s observations of it.” ([[Mees-Buss et al. 2020]], p. 409)
        - “It ignores how data are socially produced and how participants’ talk and action cannot be understood without reference to the broader social structures and processes that give them meaning (Silverman, 1989).” ([[Mees-Buss et al. 2020]], p. 410)
        - “The end result is theory that is little more than an abstracted description of informants’ accounts.” ([[Mees-Buss et al. 2020]], p. 410)
        - “Although theory-data linkages might be made transparent, that does not imply they represent the most insightful and plausible understanding of the social setting under investigation.” ([[Mees-Buss et al. 2020]], p. 410)
    - “second-generation [[grounded theorists]] {…} “explicitly rejected these inductivist foundations (Bryant, 2017), as have contemporary critics of [[grounded theory]] (e.g., Tavory & Timmermans, 2014)” ([[Mees-Buss et al. 2020]], p. 410)

### [[Gioia methodology]]

- **Roots:**
    - “A key motivation for developing the Gioia methodology was, its authors explained, “to bring ‘qualitative rigor’” to interpretive research (Gioia et al., 2013, p. 15).” ([[Mees-Buss et al. 2020]], p. 412)
    - “This template is based on a methodology developed in the 1980s, when Gioia and a co-author were seeking to publish an ethnographic study (Gioia & Chittipeddi, 1991) in a top management journal still hostile to qualitative research (Gioia, 2017; Gioia et al., 2013, p. 18). The popularity of this template soared in the years following Gioia et al.’s award-winning article published in Organizational Research Methods in 2013, in which they presented their methodology in detail (see Reay et al., 2019).” ([[Mees-Buss et al. 2020]], p. 410)
    - “The methodology reconciles interpretive research with the quantitative mainstream: The concepts and models produced from rigorous coding procedures are amenable to the development of measurable constructs that can be tested. In this way, the Gioia methodology is presented as complementary to, not as a repudiation of, “traditional” research (Gioia et al., 2013, p. 22).” ([[Mees-Buss et al. 2020]], p. 411)
    - “this methodology is aligned with the assumptions of a naturalist orientation.” ([[Mees-Buss et al. 2020]], p. 410)
        - “Although Gioia et al. (2013) referred to Van Maanen as the source for some of the key concepts they used in representing the interpretive process, these concepts were applied very differently to fit a naturalist approach.” ([[Mees-Buss et al. 2020]], p. 406)
- **3 sets of interpretive challenges tied to the unavoidable subjectivity of meaning**
    - Challenge 1: Interpreting subject field data
        - “As a “glorified reporter,” the researcher strives to report the experiences of informants with minimal distortion (Gioia et al., 2013, p. 17).” ([[Mees-Buss et al. 2020]], p. 411)
        - “The meaning of informants is then crystallized in what are termed first-order codes, a term attributed to Van Maanen (1979).” ([[Mees-Buss et al. 2020]], p. 411)
        - “**First-order codes** are defined as informant-derived categories in that they stay as close as possible to the voice of the informants themselves. The process of first-order coding is depicted as the thematic grouping of informants’ talk, with theory held at bay.” ([[Mees-Buss et al. 2020]], p. 411)
        - “Throughout this process, data are considered best left untouched (as much as is feasible) by the researcher’s prior theoretical understanding, so as not to risk “putting the blinders on” (Gioia et al., 2013, p. 21). This is consistent with the inductivist assumption that theoretical preconceptions can be bracketed when in the field.” ([[Mees-Buss et al. 2020]], p. 411)
    - Challenge 2: Confronting researcher subjectivity in theorizing the data
        - “theorizing is seen only to commence when first-order codes are converted into abstract theoretical concepts, termed **second-order codes**.” ([[Mees-Buss et al. 2020]], p. 412)
        - “distinguishing the two types of codes in this way maintains a separation between data and theory.” ([[Mees-Buss et al. 2020]], p. 412)
        - “Little guidance is provided as to how to go about the process of abstraction.” ([[Mees-Buss et al. 2020]], p. 412)
        - “The end point of these two phases of coding is a set of abstract, theoretical redescriptions of informant categories. The coding stages are summarized in an accompanying diagram—the so-called **data structure**—that resembles the visual representation of a factor analysis (Cornelissen, 2017).” ([[Mees-Buss et al. 2020]], p. 412)
        - “The final stage in the analytical process is a **“dynamic” model** (Gioia et al., 2013, p. 24) specifying the relationships between second-order concepts that could be tested for potential generalizability and more sharply defined and measurable “constructs” (Gioia et al., 2013, p. 16).” ([[Mees-Buss et al. 2020]], p. 412)
        - “Consistent with this objective, the dynamism of the model is modest. It conforms to a traditional, **linear input-output model** using “classic boxes-and-arrows terms” (Gioia et al., 2013, p. 22), linking together antecedents and consequences.” ([[Mees-Buss et al. 2020]], p. 412)
    - Challenge 3: Establishing plausibility of the theoretical conclusions
        -   “Implicitly, they regarded rigor as being procedural in nature: that is, researchers achieve it by demonstrating their use of systematic measures to structure the data and emerging theory. Rigor is largely assured by showing the faithful processing and structuring of informant talk, using clearly specified and sequential steps. This enables the reader to be able to trace the theoretical constructs (second-order) back to the data (first-order) to show that the researcher “is not making this up” (Gioia et al., 2013, p. 23).” ([[Mees-Buss et al. 2020]], p. 413)
        - “These analytical procedures can be accompanied by interrater reliability scores as “another way to bolster our own confidence in our assertions and findings” (Gioia et al., 2013, p. 22).” ([[Mees-Buss et al. 2020]], p. 413)
- **Risks:**
    - “By depicting concepts and relationships as emerging from the data, the inductive approach downplays the role of the researcher’s subjectivity during theory construction.” {…} “the Gioia methodology risks quasi-transparency because the actual theorizing process involves far more than applying analytical procedures that enable theory to “emerge” from the data.” ([[Mees-Buss et al. 2020]], p. 413)
    - “Furthermore, tying the theory too tightly to the statements of participants risks producing a theoretical account that is based on decontextualized data. The resulting interpretation may lack depth and explanatory power because it has been removed from the social setting that imbues participants’ talk with meaning.” ([[Mees-Buss et al. 2020]], p. 413)
    - “Moreover, it may lead to theory that, rather than being revelatory and insightful, is incremental in nature. Given that participant statements are elicited from questions that were asked by the researcher using existing theoretical preconceptions, the data may not serve the goal of novel theory.” ([[Mees-Buss et al. 2020]], p. 413)

### The Hermeneutic Orientation Toward Interpretation

- “researchers are engaging in interpreting the interpretations of those they study” ([[Mees-Buss et al. 2020]], p. 415)
- “invites a much more critical attitude toward the interpreted nature of data, the role of the researcher as an interpreter, and the resultant knowledge claims.” ([[Mees-Buss et al. 2020]], p. 406)
- “For researchers who adopt this hermeneutic orientation, rigor means challenging their—as well as their participants’—understanding of what is really going on or being said in the field setting” ([[Mees-Buss et al. 2020]], p. 406)
- “Revelatory theoretical insight requires interpretive rigor that relies on a process of discovery—of following redirections, clues, and new avenues of inquiry—to arrive at a deeper understanding of the social phenomena being studied.” ([[Mees-Buss et al. 2020]], p. 406)
- **Roots**:
    - [[hermeneutics]] has a “rich and varied history” in philosophy, comprising “multiple strands that range from the more critical to the realist (for a review, see Prasad, 2002; Thatchenkery, 2001; Tomkins & Eatough, 2018)” ([[Mees-Buss et al. 2020]], p. 414)
- **Key exemplars**:
    - [[Gadamer 1989]]
    - [[John Van Maanen]] - [[Van Maanen 1979]]
    - This article draws particularly on the approach to [[hermeneutics]] of [[Alfred Schütz]] (1954, 1960, 1964)
        - “origin of the concepts of first and second order.” ([[Mees-Buss et al. 2020]], p. 414)
        - “Schütz was a phenomenologist and as such advocated the need to seek understanding of the meaning with which we imbue our actions.” ([[Mees-Buss et al. 2020]], p. 414)
        - “He combined this phenomenological concern for the meaning of social action with an epistemological stance informed by the hermeneutic tradition (Eberle, 2014).” ([[Mees-Buss et al. 2020]], p. 414)
        - **First layer of interpretation / first order**
            - “Schütz {…} cautioned that theories in the social sciences that are not based on the subjective understanding of participants risk replacing “the world of social reality” with “a fictional non-existing world constructed by the scientific observer” (Schütz, 1964, p. 8). To find out what happens in a social setting, researchers must commence with an examination of what constitutes the social reality for the actors who inhabit it. The starting point is to answer: “**What does this all mean for the actor?**” (Schütz, 1960, p. 217).” ([[Mees-Buss et al. 2020]], p. 415)
            - “Although the innermost thoughts of another person are inaccessible, there is a shared or intersubjective aspect to meaning that makes this first level of interpretation possible—although not straightforward.” ([[Mees-Buss et al. 2020]], p. 415)
        - **Second layer of interpretation / second order**
            - “the **conceptual schemes of researchers**: constructs of the constructs made by the actors whose behavior the researcher tries to explain. These second-order concepts can never reach “empirical certainty” (or mathematical probability), only plausibility or subjective likelihood (Schütz, 1954).” ([[Mees-Buss et al. 2020]], p. 415)
        - “in the social sciences, theories {…} must be tested on their plausibility.” ([[Mees-Buss et al. 2020]], p. 415)
            - “They must demonstrate they are an adequate reconstruction of the social world they claim to represent; that is, they must be recognizable to those whose actions they are modeling.” ([[Mees-Buss et al. 2020]], p. 415)
            - “This, however, does not mean that there will be—or should be—correspondence between firstand second-order concepts because they **serve different purposes**. The explanatory models of the social scientist are not meant to mirror the commonsensical understanding of social actors that first-order concepts represent and are judged by different standards. In this way, Schütz insisted on the possibility of an objective social science based on the subjectivity of the social world. But for him, objective means being open to criticism and verification rather than signifying it is free from subjectivity (Gephart, 2017).” ([[Mees-Buss et al. 2020]], p. 415)
        - “Although Schütz’s influence can be seen in early work in organizational sociology (including the work of David Silverman; see Holt & Sandberg, 2011), this interest has not been maintained. The untapped potential of Schütz’s approach was noted by Gill (2014) and Gephart (2017).” ([[Mees-Buss et al. 2020]], p. 415)
- **3 sets of interpretive challenges tied to the unavoidable subjectivity of meaning**
    - Challenge 1: Interpreting subject field data
        - “problematizes the transmission of meaning, assuming that there is no ready access to participants’ subjective meaning. Even the most skillful fieldworker cannot circumvent the socially mediated nature of participants’ accounts. Although research participants in a study may be willing and able to provide full accounts of their actions, the researcher will not necessarily share the same contextual frame of reference to understand them or be able to identify and bracket out his or her own subjectivity.” ([[Mees-Buss et al. 2020]], p. 414)
        - “The hermeneutic tradition emphasizes the need for researchers to exercise suspicion by undertaking **source criticism**—that is, critically evaluating the origins and standpoint of interview accounts—and by placing these accounts (the part) in their broader context (the whole) (Alvesson & Sköldberg, 2009; Schaefer & Alvesson, 2020).” ([[Mees-Buss et al. 2020]], p. 414)
    - Challenge 2: Confronting researcher subjectivity in theorizing the data
        - “Rather than emerging from the structuring of data, analysis involves **destabilizing data**.” ([[Mees-Buss et al. 2020]], p. 414)
        - “Researchers need to expand their analytical gaze by actively questioning how, why, and where data were produced (Silverman, 1989).” ([[Mees-Buss et al. 2020]], p. 414)
        - “Theoretical insight is a result of this process, which involves researchers being prepared to relinquish their initial interpretations of participants’ talk and actions and search for a more holistic understanding of the social situation—even if this contradicts participants’ own accounts of their actions as well as the initial theoretical starting point for the study” ([[Mees-Buss et al. 2020]], p. 414)
    - Challenge 3: Establishing plausibility of the theoretical conclusions  
        - “There is indeed rigor in an interpretive study, but only if the term is recast. Rigor lies not in demonstrating a tight correspondence between data and theory through the coding process but rather in the thoroughness of the interpretive process” ([[Mees-Buss et al. 2020]], p. 414)
        - “The guiding principle in this process is being attentive to refutability (Silverman, 2020). This involves demonstrating that the research has incorporated an active search for evidence from the social setting that can refute the preliminary theoretical explanation. A theoretical explanation is only plausible when no such evidence or no better alternative explanation to explain the available evidence can be found.” ([[Mees-Buss et al. 2020]], p. 414) - _IBE, how do we know this is the best available explanation?_

### [[Van Maanen]]’s [[hermeneutic interpretivism]]

- “Unlike Schütz, who was a philosopher providing the epistemological arguments for an interpretive social science, Van Maanen considered the practical implications of a hermeneutic orientation for the researcher in the field.” ([[Mees-Buss et al. 2020]], p. 415)
- [[Van Maanen 1979]] “clearly explains his hermeneutically informed approach to interpretive research.” ([[Mees-Buss et al. 2020]], p. 415)
- See also [[Van Maanen 2011]] [[Van Maanen et al. 2007]]
- **3 sets of interpretive challenges tied to the unavoidable subjectivity of meaning**
    - Challenge 1: Interpreting subject field data
        - “In line with Schütz (1964), he used the concepts of first and second order to highlight the multiple layers of interpretation involved in transforming field data into theory.” ([[Mees-Buss et al. 2020]], p. 416)
        - “In Van Maanen’s (1979) conceptualization, **first-order concepts** represent the researcher’s interpretation of “what things ‘stand for’ to the people observed” (p. 542).” ([[Mees-Buss et al. 2020]], p. 416)
        - “It is derived from field data that can take the form either of “**operational data**”—actual behavior—or “**presentational data**”—the verbal reports provided by participants. He cautioned that the researcher cannot assume either data type represents “facts” about the social world. When it comes to operational data, even direct observation of participants can be misleading. In the case of presentational data, research participants may purposefully or unintentionally mislead the fieldworker. Even if they do not intentionally set out to deceive, they may mislead simply because they are unaware of their own biases or take them for granted and do not articulate the contextual detail that is essential to substantiate their accounts. No matter how willing they are to open up to the researcher, participants are not sufficiently reliable guides to the social worlds they inhabit to provide a sound basis for theorizing.” ([[Mees-Buss et al. 2020]], p. 416)
        - “In addition to these measures, a researcher needs to take the additional hermeneutic step of expanding the analysis from part to whole: that is, how participants’ talk and actions are “situationally, historically, and biographically mediated” (Van Maanen, 1979, p. 540).” ([[Mees-Buss et al. 2020]], p. 417)
        - “To understand the taken-for-granted social routines and rules of a social group, Van Maanen highlighted “breaches” as being one opportunity for the researcher to become aware of these rules: that is, instances when normal social routines have broken down. Such occasions allow the researcher to catch glimpses of the social structures in which organizational activities are embedded. Exceptions, outliers, rarities, and minority views can be more important in generating understanding of underlying social structures than what is frequently seen or heard (i.e., the majority view).” ([[Mees-Buss et al. 2020]], p. 418)
    - Challenge 2: Confronting researcher subjectivity in theorizing the data
        - “**Second-order concepts**, according to Van Maanen (1979), are “the researcher’s conception of what is going on” (p. 540) theoretically.” ([[Mees-Buss et al. 2020]], p. 418)
        - “Although this is seemingly close to the way Gioia et al. (2013) defined them, Van Maanen did not regard second-order concepts as abstract and aggregated labels that theoretically describe the first-order concepts; rather, they explain or illuminate first-order concepts in a revelatory way.” ([[Mees-Buss et al. 2020]], p. 418)
        - “Such **explanatory concepts** cannot be induced from the data: they are generated by the researcher.” ([[Mees-Buss et al. 2020]], p. 418)
        - “The initial second-order concepts that the researcher proposes are likely to be erroneous because they reflect the researcher’s social world and “perceptual screen” (Van Maanen, 1979, p. 547) rather than what is actually going on in the world of the participants.” ([[Mees-Buss et al. 2020]], p. 418)
        - “To minimize the potential for erroneous interpretations to persist, initial understandings need to be “tested, retested, and tested again in the field” (Van Maanen, 1979, p. 549)” ([[Mees-Buss et al. 2020]], p. 418)
        - “This process of reasoning is [[abductive]] {…}. In other words, a plausible explanation is sought for puzzling findings that current theoretical frames cannot explain (Van Maanen et al., 2007). Typically, this process involves multiple cycles of explanation seeking rather than a “bold stroke” or “ah-ha” epiphany (Van Maanen et al., 2007, p. 1148). Theory does not emerge from the data but is actively and imaginatively constructed by the researcher.” ([[Mees-Buss et al. 2020]], p. 418)
    - Challenge 3: Establishing plausibility of the theoretical conclusions  
        - “Good theories are useful, revelatory insights into the social world but not facts.” ([[Mees-Buss et al. 2020]], p. 418)
        - “interpretive studies can and should be “sound” and “faithful.” That is, researcher accounts can do better or worse at seeing and understanding what is occurring within the world of their participants.” ([[Mees-Buss et al. 2020]], p. 418)
        - “Van Maanen (1979) advised that “[s]econd-order concepts are perhaps most interesting when they do not converge [with first order-concepts] for it is here that the fieldworker may have something novel to say” (p. 541).” ([[Mees-Buss et al. 2020]], p. 419)
        - “**interpretive rigor**”
            - ““fit” between data and theory does not constitute a tight correspondence between participant statements and the abstract concepts aggregated from them. Rather, fit is achieved when the theory that has been (re)constructed offers a better explanation of “what was going on”—including the apparently anomalous data fragments—than existing theoretical frameworks do.” ([[Mees-Buss et al. 2020]], p. 419)
            - “The process of constantly testing provisional theories and searching for new clues is why lengthy time periods need to be spent in the field.” ([[Mees-Buss et al. 2020]], p. 419)

### Guiding heuristics for [[hermeneutic interpretivism]]

- An approach designed to “ensure that both the data and the patterns one detects in the data are subjected to constant interrogation, destabilization, and revision.” ([[Mees-Buss et al. 2020]], p. 419)
- Heuristics
    - “In this context, the term heuristics does not refer to mental shortcuts but rather to aids for discovery that stimulate generative thinking, creativity, and imagination” ([[Mees-Buss et al. 2020]], p. 406)
- “heuristic aids {…} distilled from Van Maanen’s methodology” ([[Mees-Buss et al. 2020]], p. 420)
    - “first set of heuristics—**data-interrogating heuristics**” ([[Mees-Buss et al. 2020]], p. 420)
    - “second set of heuristics—**theory-generating heuristics**” ([[Mees-Buss et al. 2020]], p. 420)
    - “last set of heuristics—**plausibility heuristics**” ([[Mees-Buss et al. 2020]], p. 420)
- “Indicative questions are listed in Table 3, but they are not meant to be exhaustive.” ([[Mees-Buss et al. 2020]], p. 420)
- “The same probing questions can also be used by reviewers seeking to evaluate the quality of interpretive research.” ([[Mees-Buss et al. 2020]], p. 420)

---

## Miscellaneous points